#!/bin/sh
# Install the default font set or (as custom install)
# link in all fonts from a Linux system 

echo "Current directory: `pwd`"
echo "Setup PSFonts for use with PStill"
echo 
echo "This script will search your system for font files and creates copys/symlinks in"
echo "PStills 'PSFonts' directory to provide it with a base font set."
if [ ! -d "PSFonts" ]
then
	echo "Error: Directory 'PSFonts' does not exist in current path."
	exit 1
fi 
echo
        echo "Do you want to continue?"
        while true
        do
        echo -n "Please confirm (y or n) :"
        read CONFIRM
        case $CONFIRM in
        y) break ;;
        n)
	echo "Ok - exiting."
        exit 
        ;;
        *) echo "Please enter only y or n"
        esac
        done
echo 
	echo "Do you want to use the default fontset?"
	while true
	do
	echo -n "Please confirm (y or n) :"
	read CONFIRM
	case $CONFIRM in
	y) break ;;
	n) break ;;
	*) echo "Please enter only y or n"
	esac
	done
	if [ "$CONFIRM" = "y" ]
	then
		echo "Unpacking liberation font set..."
		tar xzf pstill_liberation_fonts_215.tar.gz
		echo "Now waiting 10 sec and then setup font widths and metrics..."
		sleep 10
		./pstill64 -v -I
		echo "Installing the matching fontsub.table..."
		cp fontsub_libfonts.table fontsub.table
		echo "Ok - finished."
		echo
		echo "Now try converting a testfile by entering:"
		echo " ./pstill64 -M defaultall -o testfile.pdf testfile.ps" 
		exit 0
	fi 
echo
echo "Custom installation, trying more font sets usually available on Linux"
cd PSFonts 2> /dev/null
echo "Current directory: `pwd`"
sleep 1
NEED_REPLACEMENT_TABLE="No"
if [ -f /usr/share/fonts/type1/gsfonts/a010013l.pfb ]
then
	echo "Found GSFont set installed on this system"
	echo "The GSFont set provides a 'replacement' set for the standard base 13 font set"
	echo "and can be used in its place."
	echo 
	echo "Do you want PStill to use the GSFont set as base fonts?"
	while true
	do
	echo -n "Please confirm (y or n) :"
	read CONFIRM
	case $CONFIRM in
	y) break ;;
	n)
	echo "Ok, will not use the GSFont set"
	break	
	;;
	*) echo "Please enter only y or n"
	esac
	done
	echo "You entered $CONFIRM. Continuing..."
	if [ "$CONFIRM" = "y" ]
	then
		echo "Source is /usr/share/fonts/type1/gsfonts/*"
		echo
		sleep 1
		for file in /usr/share/fonts/type1/gsfonts/*.pfb
		do
		newname=`pwd`/`basename $file`
		echo $file
		ln -s $file $newname
		done
		NEED_REPLACEMENT_TABLE="Yes"
	fi
fi
if [ -d /usr/lib/X11/fonts/Type1 ]
then
	echo
	echo "Linking more fonts..."
	echo "Trying X11 - Source is /usr/lib/X11/fonts/Type1/*"
	echo
	sleep 1
	for file in /usr/lib/X11/fonts/Type1/*
	do
	newname=`pwd`/`basename $file`
	echo $file
	ln -s $file $newname
	done
fi
if [ -d /usr/share/cups/fonts ]
then
	echo
	echo "Linking more fonts..."
	echo "Trying CUPS - Source is /usr/share/cups/fonts/*"
	echo
	sleep 1
	for file in /usr/share/cups/fonts/*
	do
	newname=`pwd`/`basename $file`
	echo $file
	ln -s $file $newname
	done
	echo 
fi
echo
echo "Remember that PStill needs at least Courier as font otherwise"
echo "you may see black dots instead of text in the output."
echo 
echo "Waiting now 10 seconds, then starting to check & convert the fonts you just"
echo "linked in the PSFonts font pool, stand by..."
sleep 10
cd ..
./pstill64 -v -I
if [ "$NEED_REPLACEMENT_TABLE" = "Yes" ]
then
	echo
	echo "Activating the correct replacement table for the GSFont set..."
	echo "Setup: fontsub.table"
	cp fontsub.table fontsub.table_original
	cp fontsub_gsfonts.table fontsub.table
	echo
fi
echo "Done - PStill just displayed a list of installed fonts you can use"
echo "You may want to add additional fonts to PSFonts, just copy font files"
echo "of PFA or PFB type to the PSFonts directory, then run 'pstill -v -I'"
echo "again in the pstill base directory: `pwd`"
echo
echo "There are also some font related links on the PStill web page"
echo "See http://www.pstill.com for 'Other PStill and PDF related information'"
exit

