% PStill can 'draw' graphics on the output pages, script controlled
% You can activate a script in the GUI under Options->N-UP Output Options
% Or use -m pagecontrol=scriptname.sl on the command line
%
% ps_do_showpage(int pagenum) is called for each processed page
% The variable "pagenum" is set to the current page number during processing

define ps_do_showpage(pagenum) {

	% startGFX must be called before the first commands are used

	startGFX();

	% set the current color in RGB (values 0.0. to 1.0) 

	setRGBColor (0.0, 0.0, 0.0);

	% setFont() sets the font, encoding and X/Y-Sizes for the text
	% font is the 'true' font name as shown in the Fontmanager of PStill
	% encoding can be 0 for font default or 1 for ISOLatin1
	% X-Size in pts, likewise Y-Size

	% Any font installed with PStill can be used
	
	setFont("Helvetica", 0, 12, 12);

	% The drawText() call "prints" text on the current page
	% using sprintf(fmt,..., num_of_params);
	% you can also use define dynamic texts
	% parameters are
	%  text to be printed
	% x-position in pts (lower left == zero)
	% y-position in pts 
	% rotation in degree

	drawText( sprintf("Page %d",pagenum,1), ((pageWidth() / 2.0) - 20.0), 25, 0);

	% More examples to follow

	% execEPSFile() can impose an EPS on the current page, you specify the path to the
	% EPS, its position, the scaling factor and the rotation.

	% execEPSFile("/path/to/test.eps", 200, 200, 1.0, 0);

	% Draw a Rectangle in the current color but only on page 3

	% if (pagenum == 3) {
	%    drawRect(10,10,20,20);
	% }

	% or draw drectly with PostScript code

	% execPSCode ("0 0 moveto 10 10 lineto stroke");

	% There is also the possiblity to overlay complete pages
	%
	% setOverrideShowpage controls if the next showpage command should 
	% actually erases/output the page or not -
	% uncomment if you want to 'overlay' the next page in the input
	% setOverrideShowpage(1) will turn overriding ON, whereas
	% setOverrideShowpage(0) will turn overriding OFF

	% setOverrideShowpage(1);

	% 
	% ... and so on, there is no limit for the elements you can impose here

	%
	% The next call ends the page drawing
	% it MUST be called before exiting this function

	endGFX();

}


