% PStill can 'draw' graphics on the output pages, script controlled
% The variable "pagenum" is set to the current page number during processing
% See also STAMP-stampOutput for an example for transparency settings and EPS "stamping"
%
% This example draws the DSC Title, Creator, CreationDate and For comment from the input
% on the page
%
% Needs PStill 1.72.12 or newer to work
%

define ps_do_showpage(pagenum) {

	% startGFX must be called before the first commands are used

	startGFX();

	% set the current color in RGB (values 0.0. to 1.0) 
	% this is BLACK - while being default it poses as examples ;)

	setRGBColor (0.0, 0.0, 0.0);

	% This sets the font, encoding and X/Y-Sizes for the text
	% font is the 'true' font name as shown in the Fontmanager of PStill
	% encoding can currently be 0 for font default or 1 for ISOLatin1
	% X-Size in pts, likewise Y-Size

	setFont("Helvetica", 0, 12, 12);

	% This call "prints" text on the current page
	% using sprintf(fmt,..., num_of_params);
	% you can also use define dynamic texts
	% parameters are
	%  text to be printed
	% x-position in pts (lower left == zero)
	% y-position in pts 
	% rotation in degree

	drawText( dscComment(1), 25, 25, 0);   % Write %%Title info of source
	drawText( dscComment(2), 25, 55, 0);   % Write %%Creator info of source
	drawText( dscComment(3), 25, 75, 0);   % Write %%CreationDate info of source
	drawText( dscComment(4), 25, 100, 0);  % Write %%For: info of source

	% this call can impose any EPS on the page, you specify the path to the
	% EPS, its position, the scaling factor and the rotation.

	% execEPSFile("/path/to/test.eps", 200, 200, 1.0, 0);

	% Draw a Rectangle in the current color

	% drawRect(10,10,20,20);

	% Exec arbitary PostScript code

	% execPSCode ("0 0 moveto 10 10 lineto stroke");

	% setOverrideShowpage controls if the next showpage command should 
	% actually erases/output the page or not -
	% uncomment if you want to 'overlay' the next page in the input
	% setOverrideShowpage(1) will turn overriding ON, whereas
	% setOverrideShowpage(0) will turn overriding OFF

	% setOverrideShowpage(1);

	% ... and so on, there is no limit for the elements you can impose here

	% this call ends the page drawing
	% endGFX must be called before exiting this function

	endGFX();

}


