% Control script for PStill to remove any white fill areas during processing

% supress pure white fills, needs PStill 1.72.15 as of 17.01.2008 or newer to run

define interceptEOFill() {
	variable colorspace;
	variable cyan, yellow, magenta, black;

	colorspace = currentColorspace();

	(cyan,magenta,yellow,black) = currentCMYKColor();
	
	if (colorspace < 4) {  	 % we check DEVICEGRAY,RGB and CMYK Colorspaces
		if ((black + cyan + magenta + yellow) < 0.001) {	% only for pure white
			suppressOutput();
		}
	}
}

define interceptFill() {
	variable colorspace;
	variable cyan, yellow, magenta, black;

	colorspace = currentColorspace();

	(cyan,magenta,yellow,black) = currentCMYKColor();
	
	if (colorspace < 4) {  	 % we check DEVICEGRAY,RGB and CMYK Colorspaces
		if ((black + cyan + magenta + yellow) < 0.001) {	% only for pure white
			suppressOutput();
		}
	}
}

