% SL Script to control PDF generation, scale to a given size
% just change targetWidth/Height below to adapt to new sizes

% FYI: setupPage ( float translate_x, float translate_y, float rotate, float scale_x, float scale_y, int keepOnSamePage )

define pdf_page_setup(pagenum) {
	variable scaleFactor, scaleFactorX, scaleFactorY;
	variable fudgeX, fudgeY;
	variable targetWidth, targetHeight;
	
	scaleFactor = 1.0;
	scaleFactorX = 1.0;
	scaleFactorY = 1.0;	
	fudgeX = 0;
	fudgeY = 0;
	
	% Letter is 612 x 792, so setup and use floating point values!
	
	targetWidth = 612.0;
	targetHeight = 792.0;
	
	if (pageWidth() > 0) {
		scaleFactorX = targetWidth / pageWidth();
	}
	if (pageHeight() > 0) {
		scaleFactorY = targetHeight / pageHeight();
	}
	
	% keep proportions
	
	if (scaleFactorX < scaleFactorY) {
		scaleFactor = scaleFactorX;
	} else {
		scaleFactor = scaleFactorY;
	}	
	
	% fudge is to center the result
	
	fudgeX = (targetWidth - (pageWidth() * scaleFactor)) / 2.0;
	fudgeY = (targetHeight - (pageHeight() * scaleFactor)) / 2.0;	
	
	setupPage(fudgeX, fudgeY, 0.0, scaleFactor, scaleFactor, 0);	
	
	% remember to typecast for this call!
	setMediaBox(int(targetWidth),int(targetHeight));
}