% SL Script to control PDF generation, scale to a given size
% just change targetWidth/Height below to adapt to new sizes
% This script is also suitable for PDF/X and /A generation
% Also give option -M pagesizes=individual when running pstill!

% FYI: setupPage ( float translate_x, float translate_y, float rotate, float scale_x, float scale_y, int keepOnSamePage )

define pdf_page_setup(pagenum) {
	variable scaleFactor, scaleFactorX, scaleFactorY;
	variable fudgeX, fudgeY;
	variable targetWidth, targetHeight;
	
	scaleFactor = 1.0;
	scaleFactorX = 1.0;
	scaleFactorY = 1.0;	
	fudgeX = 0;
	fudgeY = 0;
	
	% SETUP HERE - target page size, use floating point values!
	
	targetWidth = 536.0;
	targetHeight = 698.0;
	
	%
	% in case the output is landscape rotate 90 degree to portrait
	
	if (currentPageWidth() > currentPageHeight()) {
		variable shiftHeight;

		if (currentPageHeight() > 0) {
			scaleFactorX = targetWidth / currentPageHeight();
		}
		if (currentPageWidth() > 0) {
			scaleFactorY = targetHeight / currentPageWidth();
		}
	
		% keep proportions
		
		if (scaleFactorX < scaleFactorY) {
			scaleFactor = scaleFactorX;
		} else {
			scaleFactor = scaleFactorY;
		}	

		% fudge is to center the result
		
		fudgeX = (targetWidth - (currentPageHeight() * scaleFactor)) / 2.0;
		fudgeY = (targetHeight - (currentPageWidth() * scaleFactor)) / 2.0;	
		
		shiftHeight = currentPageWidth() * scaleFactor;


		setupPage(fudgeX, shiftHeight + fudgeY, -90.0, scaleFactor, scaleFactor, 0);	
		
	} else { 
		% normal output, no rotation needed
		if (currentPageWidth() > 0) {
			scaleFactorX = targetWidth / currentPageWidth();
		}
		if (currentPageHeight() > 0) {
			scaleFactorY = targetHeight / currentPageHeight();
		}
	
		% keep proportions
		
		if (scaleFactorX < scaleFactorY) {
			scaleFactor = scaleFactorX;
		} else {
			scaleFactor = scaleFactorY;
		}	

		% fudge is to center the result
		
		fudgeX = (targetWidth - (currentPageWidth() * scaleFactor)) / 2.0;
		fudgeY = (targetHeight - (currentPageHeight() * scaleFactor)) / 2.0;	
		
		setupPage(fudgeX, fudgeY, 0.0, scaleFactor, scaleFactor, 0);	
	
	}

	% set page boxes
	setMediaBox(int(targetWidth), int(targetHeight));
	
	setupIndividualMediaBox(pagenum, targetWidth, targetHeight);
	
	setCropBox(0,0,targetWidth,targetHeight);
	setTrimBox(0,0,targetWidth,targetHeight);
	setBleedBox(0,0,targetWidth,targetHeight);

}