% SL Script to control PDF generation, scale to a given percentage
% just change rescaleFactor to the desired value

variable rescaleFactor = 150.0;    % change page scalefactor here
 
define pdf_page_setup(pagenum) {
	variable scaleFactorXY;
	
	scaleFactorXY = rescaleFactor / 100.0;

	logprint(sprintf("*** Original Page size %d %d\n", pageWidth(), pageHeight(), 2));

	setupPage(0, 0, 0.0, scaleFactorXY, scaleFactorXY, 0);	
	
	setMediaBox(int(pageWidth() * scaleFactorXY),int(pageHeight() * scaleFactorXY));
	
	logprint(sprintf("*** New Page size %d %d\n", int(pageWidth() * scaleFactorXY), int(pageHeight() * scaleFactorXY), 2));
}
