% SL Script to control PDF generation, do a 8 page on one, row major

define pdf_page_setup(pagenum) {
	variable onSamePage;
	variable scaleFactor;
	variable delta_x;
	variable delta_y;
	
	scaleFactor = pageWidth() / (pageHeight() * 2.0); % promote to float
	
	delta_x = pageHeight()/4.0;
	delta_y = pageWidth()/2.0;	
	
	% first find out which setup to apply
	
	onSamePage = pagenum mod 8;
	
	if (onSamePage == 1) {
		setupPage(pageWidth()-delta_y,0,90.0,scaleFactor,scaleFactor,0);		
	}
	if (onSamePage == 2) {
		setupPage(pageWidth()-delta_y,delta_x,90.0,scaleFactor,scaleFactor,1);	
	}
	if (onSamePage == 3) {
		setupPage(pageWidth()-delta_y,(2 * delta_x),90.0,scaleFactor,scaleFactor,1);	
	}
	if (onSamePage == 4) {
		setupPage(pageWidth()-delta_y,(3 * delta_x),90.0,scaleFactor,scaleFactor,1);
	}
	if (onSamePage == 5) {
		setupPage(pageWidth(),0,90.0,scaleFactor,scaleFactor,1);	
	}
	if (onSamePage == 6) {
		setupPage(pageWidth(),delta_x,90.0,scaleFactor,scaleFactor,1);	
	}
	if (onSamePage == 7) {
		setupPage(pageWidth(),(2 * delta_x),90.0,scaleFactor,scaleFactor,1);	
	}
	if (onSamePage == 0) {
		setupPage(pageWidth(),(3 * delta_x),90.0,scaleFactor,scaleFactor,1);	
	}
	
	setAnnotationPageDivider(8);	% as we put 8 page on one to correct the annotations
}

% no annotations for this run

define action_pdfmark(s,n) {

}


