% SL Script to control PDF generation, do a 4 page on one

define pdf_page_setup(pagenum) {
	variable onSamePage;
	variable scaleFactor;
	
	scaleFactor = 0.5;
	
	% first find out which setup to apply
	
	onSamePage = pagenum mod 4;
	
	% top left, top right, bottom left bottom right
	
	if (onSamePage == 1) {
		setupPage(0.0,pageHeight()/2.0,0.0,scaleFactor,scaleFactor,0);	% first page triggers new page	
	} 
	if (onSamePage == 2) {
		setupPage(pageWidth()/2.0,pageHeight()/2.0,0.0,scaleFactor,scaleFactor,1);		
	}
	if (onSamePage == 3) {
		setupPage(0.0,0.0,0.0,scaleFactor,scaleFactor,1);		
	}
	if (onSamePage == 0) {
		setupPage(pageWidth()/2.0,0.0,0.0,scaleFactor,scaleFactor,1); 		
	}
	setAnnotationPageDivider(4);	% as we put 4 page on one to correct the annotations
}

% no annotations for this run

define action_pdfmark(s,n) {

}

