% SLang Script to control PDF generation, do a 2 page on one
% more S-Lang info can be found at http://www.s-lang.org

define pdf_page_setup(pagenum) {
        variable onSamePage;
        variable scaleFactor;
        variable scaleFactor2;
        variable correctionFactor;

        scaleFactor = pageWidth() / (pageHeight() * 1.0); % promote to float
        scaleFactor2 = pageHeight() / (pageWidth() * 2.0); % promote to float

        if (scaleFactor2 < scaleFactor) scaleFactor = scaleFactor2;

        % first find out which setup to apply

        onSamePage = pagenum mod 2;

        correctionFactor = pageWidth() - (pageHeight() * scaleFactor);

        if (correctionFactor > 0) {
                correctionFactor = correctionFactor / 2.0;
        } else {
                correctionFactor = 0;
        }

        if (onSamePage == 0) {
        	setupPage(pageWidth()-correctionFactor,pageHeight()/2.0,90.0,scaleFactor,scaleFactor,1);
        } else {
        	setupPage(pageWidth()-correctionFactor,0,90.0,scaleFactor,scaleFactor,0);
        }

        setAnnotationPageDivider(2);    % as we put 2 page on one to correct the annotations targets
}

% no annotations for this run

define action_pdfmark(s,n) {

}

