% SL Script to autogenerate overprinting for text in output
% PStill 1.72.7+ needed to run
%
% Define 'intercept' functions here:
% interceptShow()   -   is called for each text op processed
% interceptFill()   -   is called for each fill op processed
% interceptStroke()   -   is called for each stroke op processed
% interceptImage()   -   is called for each image (mask) op processed
%
% We are using only interceptShow here, for we are only interested in text

define interceptShow() {
	variable fontMatrix1, fontMatrix2, fontMatrix3, fontMatrix4, fontMatrix5, fontMatrix6;
	variable fontName;
	variable colorspace;
	variable cyan, yellow, magenta, black;
	
	% logprint("Calling interceptShow\n");
	
	% get current font matrix (for unrotated text fontMatrix1 is the horizontal size in pts
	% and fontMatrix4 is the vertical size in pts
	
	(fontMatrix1, fontMatrix2, fontMatrix3, fontMatrix4, fontMatrix5, fontMatrix6) = currentFontMatrix();
	
	% optional: get the current font name (we are asking for the base font name, that is the 1)
	
	% fontName = currentFontName(1);
	
	% get the current colorspace, return values are
	% GRAY     == 1
	% RGB/HSB  == 2
	% CMYK     == 3
	% INDEXED  == 4
	% SPOT     == 5
	% PATTERN  == 6
	% DEVICEN  == 7
	
	colorspace = currentColorspace();
	
	% logprintint(colorspace);
	
	% get the current color as CMYK
	
	(cyan,magenta,yellow,black) = currentCMYKColor();
	
	if (colorspace < 4) {  	 % we process only plain DEVICEGRAY,RGB and CMYK Colorspaces
		
		% INFO: uncomment next line for debug color output as CMYK
		% logprint(sprintf("%f %f %f %f",cyan,magenta,yellow,black,4));
		
		if ((black > 0.995) and ((cyan + magenta + yellow) < 0.001)) {	% only for pure black
			if (abs(fontMatrix4) < 18.0) {				% and font size < 18
				logprint("Generate overprint for text");
				setOverprint(1);				% then generate Overprinting
			}
		}
	}
}

