% SL Script to control PDF generation, do a many on one letter size page, auto fillup
% The purpose is to have many small elements (e.g. images) and you like to fill a letter page with them.
% You can adapt the page sizes below (see variable targetpagex and targetpagey below) in pts

variable insert_point_y = -1;
variable insert_point_x = 9999;

define pdf_page_setup(pagenum) {
	variable targetpagex = 612;
	variable targetpagey = 792;
	variable borderx = 10;
	variable bordery = 10;	
	
	variable delta_y = (pageHeight() + bordery);
	
	% myprintf(" STARTUP POINT - %d Page %d\n",insert_point_y,pagenum,2);
	
	if ((insert_point_y - delta_y) < 0) {
		insert_point_y = targetpagey - pageHeight();
		if (insert_point_x > 0) {
			% emit the page, start a new one
			insert_point_x = 0;
			% myprintf(" INSERT 1 - %d\n",insert_point_y,1);
			setupPage(insert_point_x,insert_point_y,0,1,1,0);
		} else {
			% do second row
			% myprintf(" INSERT 3 - %d\n",insert_point_y,1);
			insert_point_x = insert_point_x + pageWidth() + borderx;
			setupPage(insert_point_x,insert_point_y,0,1,1,1);
		}
	} else {
		insert_point_y = insert_point_y - delta_y;
		% myprintf(" INSERT 2 - %d\n",insert_point_y,1);
		setupPage(insert_point_x,insert_point_y,0,1,1,1);	
	}
	setMediaBox(int(targetpagex),int(targetpagey));
}

% no annotations for this run

define action_pdfmark(s,n) {

}


